﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.SessionState;
using System.Data;
using System.Data.SqlClient;
using DotNet.FrameWork.Data;

namespace HteamDd.Web.ashx
{
    /// <summary>
    /// Dd_link 的摘要说明
    /// </summary>
    public class Dd_link : IHttpHandler,IRequiresSessionState
    {
        HaTeam.Dd.Model.Dd_Link model = new HaTeam.Dd.Model.Dd_Link();
        HaTeam.Dd.BLL.Dd_Link bll = new HaTeam.Dd.BLL.Dd_Link();

        HaTeam.Dd.Model.Dd_Reprint reprint_model = new HaTeam.Dd.Model.Dd_Reprint();
        HaTeam.Dd.BLL.Dd_Reprint reprint_bll = new HaTeam.Dd.BLL.Dd_Reprint();

        public void ProcessRequest(HttpContext context)
        {
            if (context.Session["link_mark_ID"] == null && context.Session["state"] != "reship_link")
            {
                int _num = Dd_LinkInsert(context);
                context.Response.Write(_num);
            }
            else if (context.Request["state"] == "link")
            {
                string link_update = "update Dd_Link set Link_Title=@title,Link_Address=@address,Link_Description=@descript,Link_Tag=@tag where Link_ID=@ID";
                SqlParameter[] links = { 
                                       new SqlParameter("@ID",SqlDbType.Int),
                                       new SqlParameter("@title",SqlDbType.NVarChar,30),
                                       new SqlParameter("@address",SqlDbType.NVarChar,100),
                                       new SqlParameter("@descript",SqlDbType.NVarChar,1000),
                                       new SqlParameter("@tag",SqlDbType.VarChar,100)
                                       };
                links[0].Value = context.Session["link_mark_ID"].ToString();
                links[1].Value = context.Request.Form["title"].ToString();
                links[2].Value = Link_Process(context.Request.Form["address"].ToString());
                links[3].Value = context.Request.Form["description"].ToString();
                links[4].Value = Lable_Prc(context);
                if (DbHelperSQL.ExecuteSql(link_update, links) != 0)
                {
                    context.Response.Write("1");
                    context.Session.Remove("link_mark_ID");
                }
                else
                {
                    context.Response.Write("-1");
                }
            }
            else if (context.Session["state"] == "reship_link")
            {
                reprint_model.Reprint_ArticleID = Convert.ToInt32(context.Request["ArticleID"]);
                reprint_model.Reprint_CopyFrom = Convert.ToInt32(context.Request["CopyFrom"]);
                reprint_model.Reprint_OriginID = Convert.ToInt32(context.Request["originID"]);
                reprint_model.Reprint_UserID = Convert.ToInt32(context.Request["userID"]);
                reprint_model.Reprint_Order = Convert.ToInt32(context.Request["Order"]);
                reprint_model.Reprint_Datetime = System.DateTime.Now;
                reprint_model.Reprint_UpDatetime = System.DateTime.Now;
                reprint_model.Reprint_Verify = 0;
                reprint_model.Reprint_type = 3;
                reprint_model.Reprint_State = 0;
                reprint_model.Reprint_Remark = null;
                reprint_model.Reprint_Lock = 0;
                reprint_model.Reprint_Guid = Guid.NewGuid().ToString();
                reprint_model.Reprint_Delete = 0;
                reprint_model.Reprint_Count = 0;
                int _num =0;
                try
                {
                    _num = reprint_bll.Add(reprint_model);
                    if (_num!=0)
                    {
                        _num = 1;
                        Dd_LinkInsert(context);
                    }
                }
                catch
                { 
                    _num = 0; 
                }
                context.Response.Write(_num);
            }
        }

        private int Dd_LinkInsert(HttpContext context)
        {
            string title = context.Request["title"].ToString();
            string linkaddress = context.Request["address"].ToString();
            string description = context.Request["description"].ToString();
            string istop = context.Request["istop"].ToString();
            string link = Link_Process(linkaddress);

            model.User_ID = Convert.ToInt32(context.Request["userID"].ToString());
            model.Link_Title = title;
            model.Link_Address = link;
            model.Link_Description = description;
            model.Link_Tag =Lable_Prc(context);
            model.Link_PublishMode = 1;
            model.Link_PutTop = Convert.ToBoolean(istop);
            model.Link_Fever = 0;
            model.Link_OriginId = model.User_ID;
            model.Link_Guid = Convert.ToString(Guid.NewGuid());
            model.Link_Datetime = DateTime.Now;
            model.Link_UpDatetime = DateTime.Now;
            model.Link_Verify = 0;
            model.Link_Lock = 0;
            model.Link_State = 0;
            model.Link_Delete = 0;
            model.Link_Count = 0;
            model.Link_Order = 3;
            int _num = 0;
            try
            {
                _num = bll.Add(model);
                if (_num != 0)
                {
                    _num = 1;
                }
            }
            catch
            {
                _num = -1;
            }
            return _num;
        }

        private static string Link_Process(string linkaddress)
        {
            string link = linkaddress.Substring(0, 7);
            if (link == "http://")
            {
                link = linkaddress;
            }
            else
            {
                link = "http://" + linkaddress;
            }
            return link;
        }
        /// <summary>
        /// 对标签的处理
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        private static string Lable_Prc(HttpContext context)
        {
            string lable = "";
            if (context.Request.Params["lable"] == "")
            {
                if (context.Request.Params["title"] != "" & context.Request.Params["description"] == "")
                {
                    lable = context.Request.Params["title"].ToString().Substring(0, 2);
                }
                else if (context.Request.Params["description"] != "" & context.Request.Params["title"] == "")
                {
                    lable = context.Request.Params["description"].ToString().Substring(0, 2);
                }
                else if (context.Request.Params["description"] == "" & context.Request.Params["title"] == "")
                {
                    lable = context.Request.Params["address"].ToString().Substring(0, 2);
                }
                else
                {
                    lable = context.Request.Params["title"].ToString().Substring(0, 2);
                }
            }
            else
            {
                lable = context.Request.Params["lable"].ToString();
            }
            return lable;
        }
        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}